#!/usr/local/bin/ruby -Ke

require 'gtk' # gtkθƽ

window = Gtk::Window.new()
window.signal_connect('delete_event'){ Gtk::main_quit } # λ٥

drawing_area = Gtk::DrawingArea.new()  # ɥꥢκ
drawing_area.set_usize(500, 400)  # ɥꥢ礭
window.add(drawing_area)

drawing_area.signal_connect("expose_event") do |drawing_area, event| # 
	drawable = drawing_area.window  # ɥ֥Ф
	gc = Gdk::GC.new(drawable)  # GC
	colormap = Gdk::Colormap.get_system()  # 顼ޥåפμФ

	# Ѥɽ
	(0..2).each do |i|
		line_width = i * 5 + 1
		line_y = i * 25 + 20

		color = Gdk::Color.new(0x4000 * i, 0x4000 * i, 0x4000 * i)
		colormap.alloc_color(color, nil, true)    # color˥顼ޥåפ
		gc.set_foreground(color)  # GCΥե饦ɤcolor
		gc.set_line_attributes(line_width, Gdk::LINE_SOLID, Gdk::CAP_ROUND, Gdk::JOIN_MITER)  # °

		drawable.draw_line(gc, 40, line_y, 260, line_y) # 
	end

	# ޤɽ
	color = Gdk::Color.new(0xffff, 0x7fff, 0x7fff)
	colormap.alloc_color(color, nil, true)    # color˥顼ޥåפ
	line_width = 20

	cap_styles = [Gdk::CAP_BUTT, Gdk::CAP_ROUND, Gdk::CAP_PROJECTING]
	join_styles = [Gdk::JOIN_MITER, Gdk::JOIN_ROUND, Gdk::JOIN_BEVEL]

	(0..2).each do |i|
		line_y = i * 100 + 100

		gc.set_foreground(color)  # GCΥե饦ɤcolor
		gc.set_line_attributes(line_width, Gdk::LINE_SOLID, cap_styles[i], join_styles[i])  # °

		points = [
			[50, line_y],
			[200, line_y],
			[200, line_y+50],
			[250, line_y+70],
			[300, line_y+70],
		]
		drawable.draw_lines(gc, points) # ޤ
	end

	# 
	color = Gdk::Color.new(0x0000, 0x7fff, 0xffff)
	colormap.alloc_color(color, nil, true)    # color˥顼ޥåפ
	line_width = 5

	line_styles = [Gdk::LINE_SOLID, Gdk::LINE_ON_OFF_DASH, Gdk::LINE_DOUBLE_DASH]
	(0..2).each do |i|
		line_x = i * 30 + 350

		gc.set_foreground(color)  # GCΥե饦ɤcolor
		gc.set_line_attributes(line_width, line_styles[i], Gdk::CAP_BUTT, Gdk::JOIN_MITER)  # °

		drawable.draw_line(gc, line_x, 40, line_x, 260) # 
	end
end

window.show_all
Gtk.main

