#!/usr/local/bin/ruby -Ke

require 'gtk' # gtkθƽ

window = Gtk::Window.new()
window.signal_connect('delete_event'){ Gtk::main_quit } # λ٥

drawing_area = Gtk::DrawingArea.new()  # ɥꥢκ
drawing_area.set_usize(200, 200)  # ɥꥢ礭
window.add(drawing_area)

drawing_area.signal_connect("expose_event") do |drawing_area, event| # 
	drawable = drawing_area.window  # ɥ֥Ф
	gc = Gdk::GC.new(drawable)  # GC
	colormap = Gdk::Colormap.get_system()  # 顼ޥåפμФ

	# Ѥɽ
	lines = [Gdk::LINE_SOLID, Gdk::LINE_SOLID, Gdk::LINE_SOLID]
	caps = [Gdk::CAP_BUTT, Gdk::CAP_ROUND, Gdk::CAP_PROJECTING]
	joins = [Gdk::JOIN_MITER, Gdk::JOIN_ROUND, Gdk::JOIN_BEVEL]

	(0..2).each do |i|
		line_width = i * 5 + 1
		box_x = i * 25 + 20
		box_y = i * 25 + 20

		color = Gdk::Color.new(0x4000 * i, 0x4000 * i, 0x4000 * i)
		colormap.alloc_color(color, nil, true)    # color˥顼ޥåפ
		gc.set_foreground(color)  # GCΥե饦ɤcolor
		gc.set_line_attributes(line_width, lines[i], caps[i], joins[i])  # °

		drawable.draw_rectangle(gc, false, box_x, box_y, 100, 100) # ͳѤ
	end
end

window.show_all
Gtk.main
