#!/usr/local/bin/ruby -Ke

require 'gtk' # gtkθƽ

window = Gtk::Window.new()
window.signal_connect('delete_event'){ Gtk::main_quit } # λ٥

drawing_area = Gtk::DrawingArea.new()  # ɥꥢκ
drawing_area.size(80, 80)  # ɥꥢ礭
window.add(drawing_area)

drawing_area.signal_connect("expose_event") do |drawing_area, event| # 
	drawable = drawing_area.window  # ɥ֥Ф
	gc = Gdk::GC.new(drawable)  # GC
	colormap = Gdk::Colormap.get_system()  # 顼ޥåפμФ

	# Ѥɽ
	(0..5).each do |i|
		box_x = i * 10 + 10
		box_y = i * 10 + 10

		color = Gdk::Color.new(0x1fff * i, 0x1fff * i, 0x1fff * i)
		colormap.alloc_color(color, nil, true)    # color˥顼ޥåפ
		gc.set_foreground(color)  # GCΥե饦ɤcolor

		drawable.draw_point(gc, box_x, box_y) # 

		points = [
			[box_x, box_y+10],
			[box_x+1, box_y+10],
			[box_x+2, box_y+10],
		]
		drawable.draw_points(gc, points) # Ϣ³
	end
end

window.show_all
Gtk.main

