#!/usr/local/bin/ruby -Ke

require 'gtk' # gtkθƽ

Cross_arr = [
"10 10 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #FF0000",
"   .++.   ",
"   .++.   ",
"   .++.   ",
"....++....",
"++++++++++",
"++++++++++",
"....++....",
"   .++.   ",
"   .++.   ",
"   .++.   ",
]
Cross_width = 10
Cross_height = 10

Tile_arr = [
"6 6 3 1",
" 	c None",
".	c #AFAFFF",
"+	c #AFFFFF",
"...+++",
"..+++.",
".+++..",
"+++...",
"++...+",
"+...++",
]
Tile_width = 6
Tile_height = 6


window = Gtk::Window.new()
window.signal_connect('delete_event'){ Gtk::main_quit } # λ٥

drawing_area = Gtk::DrawingArea.new()  # ɥꥢκ
drawing_area.set_usize(60, 60)  # ɥꥢ礭
window.add(drawing_area)

window.realize
$tile_pixmap, $tile_mask = Gdk::Pixmap.create_from_xpm_d(window.window, nil, Tile_arr)

# mask夬äƤ
$cross_pixmap, $cross_mask = Gdk::Pixmap.create_from_xpm_d(window.window, nil, Cross_arr)

$pixmap = nil
drawing_area.signal_connect("configure_event") do |drawing_area, event|
	drawable = drawing_area.window  # ɥ֥Ф

	# ԥޥåפ
	$pixmap = Gdk::Pixmap.new(drawable,
		drawing_area.allocation.width, drawing_area.allocation.height, -1)

	gc = Gdk::GC.new($pixmap)  # GC
	colormap = Gdk::Colormap.get_system()  # 顼ޥåפμФ

	# طʤɥ֥ߤͤ
	x = 0
	while(x < drawing_area.allocation.width)
		y = 0
		while(y < drawing_area.allocation.height)
			$pixmap.draw_pixmap(gc, $tile_pixmap, 0, 0, x, y, Tile_width, Tile_height)
			y += Tile_height
		end
		x += Tile_width
	end

	# طʤξ˽ɽ
	gc.set_clip_mask($cross_mask) # Υޥ

	x = 20
	y = 10
	gc.set_clip_origin(x, y) # Υץ饤ΰθ

	$pixmap.draw_pixmap(gc, $cross_pixmap, 0, 0, x, y, Cross_width, Cross_height)

	gc.set_clip_mask(nil) # Υޥ

	gc.destroy # GC˴
end

drawing_area.signal_connect("expose_event") do |drawing_area, event| # 
	drawable = drawing_area.window  # ɥ֥Ф
	gc = Gdk::GC.new(drawable)  # GC
	drawable.draw_pixmap(gc, $pixmap, 0, 0, 0, 0,
	 drawing_area.allocation.width, drawing_area.allocation.height)
	gc.destroy # GC˴
end

window.show_all
Gtk.main

