#!/usr/local/bin/ruby -Ke

require 'gtk' # gtkθƽ

$window = Gtk::Window.new()
$window.signal_connect('delete_event'){ Gtk::main_quit } # λ٥

vbox = Gtk::VBox.new() # VBoxκ
$window.add(vbox)

drawing_area = Gtk::DrawingArea.new()  # ɥꥢκ
drawing_area.size(100, 100)  # ɥꥢ礭
vbox.pack_start(drawing_area)

sw = Gtk::ScrolledWindow.new()  # 륦ɥκ
sw.set_usize(100, 200)  # 륦ɥ礭
vbox.pack_start(sw)

$text = Gtk::Text.new()  # ȥ꡼κ
$text.set_editable(false)
sw.add($text)

$window.show_all

$Key_up = $Key_down = $Key_right = $Key_left = $Key_shift = nil

$window.set_events(Gdk::KEY_PRESS_MASK | Gdk::KEY_RELEASE_MASK)

$window.signal_connect("key_press_event") do |widget, event|
	case event.keyval
	when Gdk::GDK_Up      then $Key_up = true
	when Gdk::GDK_Down    then $Key_down = true
	when Gdk::GDK_Right   then $Key_right = true
	when Gdk::GDK_Left    then $Key_left = true
	when Gdk::GDK_Shift_L then $Key_shift = true
	end
end

$window.signal_connect("key_release_event") do |widget, event|
	$Key_shift = nil if event.keyval == Gdk::GDK_Shift_L
end

Gtk.timeout_add(200) do
	if $Key_up
		$text.insert_text("up\n", $text.get_length)
		$Key_up = nil
	end
	if $Key_down
		$text.insert_text("down\n", $text.get_length)
		$Key_down = nil
	end
	if $Key_right
		$text.insert_text("right\n", $text.get_length)
		$Key_right = nil
	end
	if $Key_left
		$text.insert_text("left\n", $text.get_length)
		$Key_left = nil
	end

	$text.insert_text("shift\n", $text.get_length) if $Key_shift
	true
end

Gtk.main
