#!/usr/local/bin/ruby -Ku

require "gtk2"
Gtk.init

#window = Gtk::Window.new(Gtk::WINDOW_TOPLEVEL) # ウィンドウ作成
window = Gtk::Window.new(Gtk::Window::TOPLEVEL) # ウィンドウ作成
window.set_title("Calender") # タイトルを付ける

window.signal_connect('delete_event') do # 終了イベント
	Gtk::main_quit # 終了
end


table = Gtk::Table.new(7, 1, false) # Gtk::Tabelの作成

# 曜日の作成
weeks = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'] # 曜日の設定
week_label = []
weeks.each_index do |i| # 曜日ループ
	week_label[i] = Gtk::Label.new(weeks[i]) # Labelに曜日を入れて標示
	table.attach(week_label[i], i, i+1, 0, 1) # Labelをtableの中に入れる
	week_label[i].show # ボタンの表示
end

# 今日の年,月を確認
year = Time.now.year
month = Time.now.month

=begin
配列month_calenに曜日情報を入れる
6月1日が月曜の場合は1が入る。
=end

# 該当月の日データを作成
month_calen = []
(1..31).each do |day|
	one_day = Time.local(year, month, day, 0, 0, 0)
	if one_day.month == month
		month_calen[day] = one_day.wday
	end
end

# 日データを表示
x = 0
y = 0
day_label = []

# 日データ毎にループ
(1 .. month_calen.length).each do |day|
	break unless month_calen[day]

	# 1日だったらそのまえの
	if day == 1
		x += month_calen[day]
	end

	label_no = x + (y * 7)
	day_label[label_no] = Gtk::Label.new("#{day}")
	table.attach(day_label[label_no], x, x + 1, y + 1, y + 2)
	day_label[label_no].show
	x += 1

	if month_calen[day] == 6
		y += 1
		x = 0
	end
end

window.add(table) # ウィンドウにtableを追加
table.show # tableの表示

window.show # ウィンドウの表示

Gtk.main # Gtkのループに入る

