#!/usr/local/bin/ruby -Ku

require "gtk2"
Gtk.init

window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント

box = Gtk::VBox.new()

$label = Gtk::Label.new("0")
box.pack_start($label)

tbutton = Gtk::ToggleButton.new("Start / Stop")
box.pack_start(tbutton)

tbutton.signal_connect('toggled') do  # トグルボタンを押す
	$counter = 0
	$start_time = Time.now
	$label.set_text(sprintf("%f", $counter))

#	if tbutton.active                   # 押してアクティブなら
	if tbutton.active?                   # 押してアクティブなら
		$timeout_tag = Gtk.timeout_add(10) do
			$counter = Time.now.to_f - $start_time.to_f
			$label.set_text(sprintf("%f", $counter))
			true
		end
	else                              # 押してアクティブでないなら
		Gtk.timeout_remove($timeout_tag)
		$timeout_tag = nil
	end
end

window.add(box)
window.show_all

Gtk.main
