#!/usr/local/bin/ruby -Ku

=begin
GTK2CListがなくなって、代わりにListStoreを使うようになったので、大幅な変更あり
Ruby/GTK2のサンプルプログラムを参考にしています

リストタイトル部分には、column1とcolumn2
実データ部分には、
1行目、1, 2
2行目、2, 3
3行目、a, b
4行目、-, +
=end

require "gtk2"
Gtk.init

window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント


# 大元のウィジェット作成
# このときに、データ部分に入れる、データ型を定義しておく
# この場合は、2列で、文字列と文字列と整数
model = Gtk::ListStore.new(String, String, Integer) 

# タイトル部分を作成
treeview = Gtk::TreeView.new(model) # create tree view

["column1", "column2", "column3"].each_with_index do |title, i|
	renderer = Gtk::CellRendererText.new
	# 第1引数は、タイトル名、第2引数は、CellRendererText、第3引数は、表示位置などのオプション
	column = Gtk::TreeViewColumn.new(title, renderer, 'text' => i)
	column.set_sort_column_id(i)
	treeview.append_column(column)
end

# データ部分を作成
(0..9).each do |line|
	iter = model.append
	iter.set_value(0, "cat#{line}")
	iter.set_value(1, "dog#{line}")
	iter.set_value(2, line) # ListStoreインスタンス生成時にIntegerを指定していれば、整数なども入る
end

window.add(treeview)


#clist = Gtk::CList.new(["column1", "column2", "column3"])
#
#pline = []
#(0..9).each do |line|
#	pline[line] = clist.append(["cat#{line}", "dog#{line}", "fish#{line}"])
#end
#
#clist.remove_row(2)
#window.add(clist)

window.show_all

Gtk.main

