#!/usr/local/bin/ruby -Ku

=begin
GTK2CListがなくなって、代わりにListStoreを使うようになったので、大幅な変更あり
Ruby/GTK2のサンプルプログラムを参考にしています

リストタイトル部分には、column1(String)とcolumn2(String)とImage(Gdk::Pixbuf)
=end

require "gtk2"
Gtk.init

window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント


# 大元のウィジェット作成
# このときに、データ部分に入れる、データ型を定義しておく
# この場合は、2列で、文字列と文字列と画像
model = Gtk::ListStore.new(String, String, Gdk::Pixbuf) 

# タイトル部分を作成
treeview = Gtk::TreeView.new(model) # create tree view

["column1", "column2"].each_with_index do |title, i|
	renderer = Gtk::CellRendererText.new
	# 第1引数は、タイトル名、第2引数は、CellRendererText、第3引数は、表示位置などのオプション
	column = Gtk::TreeViewColumn.new(title, renderer, 'text' => i)
	column.set_sort_column_id(i)
	treeview.append_column(column)
end

renderer = Gtk::CellRendererPixbuf.new
column = Gtk::TreeViewColumn.new("Image", renderer, {:pixbuf => 2 })
treeview.append_column(column)


pb = Gdk::Pixbuf.new('test.xpm')
#pb = window.render_icon(Gtk::Stock::OK, Gtk::IconSize::MENU, "icon")

# データ部分を作成
(0..9).each do |line|
	iter = model.append
	iter.set_value(0, "cat#{line}")
	iter.set_value(1, "dog#{line}")
	iter.set_value(2, pb)
end

window.add(treeview)


#clist = Gtk::CList.new(["column1", "column2", "column3"]) #CList
#window.add(clist)
#pline = []
#(0..9).each do |line|
#	pline[line] = clist.append(["cat#{line}", "dog#{line}", "fish#{line}"])
#end
#clist.set_text(0, 0, "TEXT")
#pix, mask = Gdk::Pixmap.create_from_xpm(window.window, nil, 'test.xpm')
#clist.set_pixmap(1, 0, pix, mask)

window.show_all

Gtk.main

