#!/usr/local/bin/ruby -Ku

=begin
GTK2CListがなくなって、代わりにListStoreを使うようになったので、大幅な変更あり
Ruby/GTK2のサンプルプログラムを参考にしています
=end

require "gtk2"
Gtk.init

window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント

# 大元のウィジェット作成
# このときに、データ部分に入れる、データ型を定義しておく
# この場合は、2列で、文字列と文字列と整数
model = Gtk::ListStore.new(String, String, Integer) 

# タイトル部分を作成
$treeview = Gtk::TreeView.new(model) # create tree view

["column1", "column2", "column3"].each_with_index do |title, i|
	renderer = Gtk::CellRendererText.new
	# 第1引数は、タイトル名、第2引数は、CellRendererText、第3引数は、表示位置などのオプション
	column = Gtk::TreeViewColumn.new(title, renderer, 'text' => i)
	column.set_sort_column_id(i)

	if i == 0
		column.set_alignment(1.0) # 0.0だとカラムタイトルを左寄せ
	elsif i == 1
		column.set_alignment(0.5) # 1.0だとカラムタイトルを左寄せ 0.5だと中央寄せ
	else
		column.set_alignment(0.0) # 1.0だとカラムタイトルを左寄せ 0.5だと中央寄せ
	end

	$treeview.append_column(column)
end

# データ部分を作成
(0..9).each do |line|
	iter = model.append
	iter.set_value(0, "cat#{line}")
	iter.set_value(1, "dog#{line}")
	iter.set_value(2, line) # ListStoreインスタンス生成時にIntegerを指定していれば、整数なども入る
end

$treeview.selection.set_mode( Gtk::SELECTION_EXTENDED )

window.add($treeview)


window.show_all

Gtk.main



=begin
$clist.set_selection_mode( Gtk::SELECTION_EXTENDED )

$clist.set_column_justification( 0, Gtk::JUSTIFY_LEFT )
$clist.set_column_justification( 1, Gtk::JUSTIFY_RIGHT )
$clist.set_column_justification( 2, Gtk::JUSTIFY_CENTER )
$clist.set_column_justification( 3, Gtk::JUSTIFY_FILL )

pline = []
(0..9).each do |line|
	pline[line] = $clist.append(["cat#{line}", "dog#{line}", "fish#{line}", "flower "*rand(10).to_i])
end

button =Gtk::Button.new("BUTTON")
button.signal_connect("clicked") do
	$clist.each_selection do |i|
		print "selected line number is #{i}\n"
	end
end
box.pack_start(button)

window.show_all

Gtk.main
=end
