#!/usr/local/bin/ruby -Ku

require "gtk2"
Gtk.init

window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント

# 大元のウィジェット作成
# このときに、データ部分に入れる、データ型を定義しておく
# この場合は、2列で、文字列と文字列と整数
model = Gtk::ListStore.new(String, String, Integer) 

# タイトル部分を作成
treeview = Gtk::TreeView.new(model) # create tree view

["column1", "column2", "column3"].each_with_index do |title, i|
	renderer = Gtk::CellRendererText.new
	# 第1引数は、タイトル名、第2引数は、CellRendererText、第3引数は、表示位置などのオプション
	column = Gtk::TreeViewColumn.new(title, renderer, 'text' => i)
	column.set_sort_column_id(i)
	treeview.append_column(column)
end

# データ部分を作成
(0..9).each do |line|
	iter = model.append
	iter.set_value(0, "cat#{line}")
	iter.set_value(1, "dog#{line}")
	iter.set_value(2, line) # ListStoreインスタンス生成時にIntegerを指定していれば、整数なども入る
end

treeview.selection.set_mode( Gtk::SELECTION_EXTENDED )

treeview.signal_connect("cursor-changed") do |widget| # クリックなどカーソル移動時
	print "cursor-changed #{widget}\n"

	widget.selection.selected_each do|model, path, iter|
		puts iter.get_value(0)
		puts iter.get_value(1)
		puts iter.get_value(2)
	end
end

treeview.signal_connect("row-activated") do |widget, path, column| # ダブルクリックすると発生する
	print "row-activated #{widget} #{path} #{column}\n"
end


window.add(treeview)
window.show_all
Gtk.main


=begin
clist = Gtk::CList.new(["column1", "column2", "column3"])
window.add(clist)

clist.set_selection_mode( Gtk::SELECTION_EXTENDED )

pline = []
(0..9).each do |line|
	pline[line] = clist.append(["cat#{line}", "dog#{line}", "fish#{line}"])
end

clist.signal_connect("select_row") do |widget, row, column, event|
	print "select #{widget} #{row} #{column} #{event}\n"
end
clist.signal_connect("unselect_row") do |widget, row, column, event|
	print "unselect #{widget} #{row} #{column} #{event}\n"
end
clist.signal_connect("click_column") do |widget, column|
	print "click_column  #{widget} #{column}\n"
end

window.show_all

Gtk.main
=end
