#!/usr/local/bin/ruby -Ku

require "gtk2"
Gtk.init

window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント

# 大元のウィジェット作成
# このときに、データ部分に入れる、データ型を定義しておく
# この場合は、2列で、文字列と文字列と整数
model = Gtk::ListStore.new(String, String, Integer, Integer) 

# タイトル部分を作成
treeview = Gtk::TreeView.new(model) # create tree view

["column1", "column2", "column3", "column4"].each_with_index do |title, i|
	renderer = Gtk::CellRendererText.new
	# 第1引数は、タイトル名、第2引数は、CellRendererText、第3引数は、表示位置などのオプション
	column = Gtk::TreeViewColumn.new(title, renderer, 'text' => i)
	column.set_sort_column_id(i)

	if i == 0         # 固定幅で50px
		column.sizing = Gtk::TreeViewColumn::FIXED
		column.fixed_width = 50
	elsif i == 1      # 自動で決まる
		column.sizing = Gtk::TreeViewColumn::AUTOSIZE
	else
		column.sizing = Gtk::TreeViewColumn::GROW_ONLY
	end

	treeview.append_column(column)
end

# データ部分を作成
(0..9).each do |line|
	iter = model.append
	iter.set_value(0, "cat#{line}")
	iter.set_value(1, "dog#{line}")
	iter.set_value(2, line) # ListStoreインスタンス生成時にIntegerを指定していれば、整数なども入る
	iter.set_value(3, line+10)
end

window.add(treeview)
window.show_all
Gtk.main




=begin
#!/usr/local/bin/ruby -Ke

require 'gtk' # gtkの呼出

window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント

clist = Gtk::CList.new(["column1", "column2", "column3", "column4"])
window.add(clist)

pline = []
(0..9).each do |line|
	pline[line] = clist.append(["cat#{line}", "dog#{line}", "fish"*rand(4).to_i, "flower "*rand(4).to_i])
end

clist.set_column_width( 0, 10 )
clist.set_column_resizeable( 0, false )

clist.set_column_width( 1, 20 )
clist.set_column_resizeable( 1, true )

clist.set_column_auto_resize( 2, true )
clist.set_column_resizeable( 2, false )

clist.set_column_auto_resize( 3, true )
clist.set_column_resizeable( 3, true )

clist.set_row_height( 20 )

window.show_all

Gtk.main
=end

