#!/usr/local/bin/ruby -Ke

require 'gtk' # gtkθƽ

Cross_arr = [
"10 10 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #FF0000",
"   .++.   ",
"   .++.   ",
"   .++.   ",
"....++....",
"++++++++++",
"++++++++++",
"....++....",
"   .++.   ",
"   .++.   ",
"   .++.   ",
]
Cross_width = 10
Cross_height = 10

Tile_arr = [
"6 6 3 1",
" 	c None",
".	c #AFAFFF",
"+	c #AFFFFF",
"...+++",
"..+++.",
".+++..",
"+++...",
"++...+",
"+...++",
]
Tile_width = 6
Tile_height = 6

window = Gtk::Window.new()
window.signal_connect('delete_event'){ Gtk::main_quit } # λ٥

vbox = Gtk::VBox.new
window.add(vbox)

$drawing_area = Gtk::DrawingArea.new()  # ɥꥢκ
$drawing_area.size(60, 60)  # ɥꥢ礭
vbox.pack_start($drawing_area)

window.realize
$tile_pix, $tile_mask = Gdk::Pixmap.create_from_xpm_d(window.window, nil, Tile_arr)
$cross_pix, $cross_mask = Gdk::Pixmap.create_from_xpm_d(window.window, nil, Cross_arr)

$current_pix = nil
$bg_pix = nil

$x = 20
$y = 0
$move_x = 0
$move_y = 1

$drawing_area.signal_connect("configure_event") do |drawing_area, event|
	drawable = drawing_area.window  # ɥ֥Ф

	draw_width = drawing_area.allocation.width
	draw_height = drawing_area.allocation.height

	# ԥޥåפ
	$bg_pix = Gdk::Pixmap.new(drawable, draw_width, draw_height, -1)

	gc = Gdk::GC.new($bg_pix)  # GC
	colormap = Gdk::Colormap.get_system()  # 顼ޥåפμФ

	# $bg_pixߤͤ
	x = 0
	while(x < draw_width)
		y = 0
		while(y < draw_height)
			$bg_pix.draw_pixmap(gc, $tile_pix, 0, 0, x, y, Tile_width, Tile_height)
			y += Tile_height
		end
		x += Tile_width
	end

	# $bg_pix$current_pix˥ԡ
	$current_pix = nil if $current_pix
	$current_pix = Gdk::Pixmap.new(drawable, draw_width, draw_height, -1)
	$current_pix.draw_pixmap(gc, $bg_pix, 0, 0, 0, 0, draw_width, draw_height)

	gc.destroy # GC˴
end

$drawing_area.signal_connect("expose_event") do |drawing_area, event| # 
	drawable = drawing_area.window  # ɥ֥Ф
	gc = Gdk::GC.new(drawable)  # GC
	drawable.draw_pixmap(gc, $current_pix, 0, 0, 0, 0,
	 drawing_area.allocation.width, drawing_area.allocation.height)
	gc.destroy # GC˴
end

Gtk.timeout_add(100) do
	drawable = $drawing_area.window  # ɥ֥Ф
	draw_width = $drawing_area.allocation.width
	draw_height = $drawing_area.allocation.height

	gc = Gdk::GC.new($bg_pix)  # GC

	$current_pix.draw_pixmap(gc, $bg_pix, 0, 0, 0, 0, draw_width, draw_height) # طʤcurrect

	$x += $move_x # ư
	$y += $move_y

	$x = 0 if draw_width < $x # ü˹Ԥä᤹
	$y = 0 if draw_height < $y

	# طʤξ˽ɽ
	gc.set_clip_mask($cross_mask) # Υޥ
	gc.set_clip_origin($x, $y) # Υץ饤ΰθ
	$current_pix.draw_pixmap(gc, $cross_pix, 0, 0, $x, $y, Cross_width, Cross_height)
	gc.set_clip_mask(nil) # Υޥ

	# ɽ
	drawable.draw_pixmap(gc, $current_pix, 0, 0, 0, 0, draw_width, draw_height)

	gc.destroy # GC˴
	true
end

window.show_all
Gtk.main
