#!/usr/local/bin/ruby -Ku

require "gtk2"
Gtk.init
require 'kconv' # gtkの呼出

class Editor
	Codes = ["EUC", "SJIS"]  # 文字コード
	Enters = ["LF", "CR+LF", "CR"]   # 改行コード
	Title = "Editor"

	def yes_no_cancel_dialog(confirm_message, yes_proc, no_proc, cancel_proc)  # YES NO CANCELダイアログ
		@dialog = Gtk::Dialog.new() # ウィンドウ作成
		@dialog.set_window_position(Gtk::Window::Position::CENTER) # 中央表示

		yes_button = Gtk::Button.new("YES")
		yes_button.signal_connect("clicked"){ yes_proc.call(); @dialog.destroy }
		@dialog.action_area.pack_start(yes_button)

		no_button = Gtk::Button.new("NO")
		no_button.signal_connect("clicked"){ no_proc.call(); @dialog.destroy }
		@dialog.action_area.pack_start(no_button)

		cancel_button = Gtk::Button.new("CANCEL")
		cancel_button.signal_connect("clicked"){ cancel_proc.call(); @dialog.destroy }
		@dialog.action_area.pack_start(cancel_button)

		label = Gtk::Label.new(confirm_message)
		@dialog.vbox.pack_start(label)

		@dialog.set_modal(true)
		@dialog.show_all
	end

	def confirm_dialog(confirm_message, ok_proc, cancle_proc)  # 確認ダイアログ
		@dialog = Gtk::Dialog.new() # ウィンドウ作成
		@dialog.set_window_position(Gtk::Window::Position::CENTER) # 中央表示

		ok_button = Gtk::Button.new("OK")
		ok_button.signal_connect("clicked"){ ok_proc.call(); @dialog.destroy }
		@dialog.action_area.pack_start(ok_button)

		cancel_button = Gtk::Button.new("CANCEL")
		cancel_button.signal_connect("clicked"){ cancle_proc.call(); @dialog.destroy }
		@dialog.action_area.pack_start(cancel_button)

		label = Gtk::Label.new(confirm_message)
		@dialog.vbox.pack_start(label)

		@dialog.set_modal(true)
		@dialog.show_all
	end

	def info_dialog(info_message)  # 情報表示ダイアログ
		@dialog = Gtk::Dialog.new() # ウィンドウ作成
		@dialog.set_window_position(Gtk::Window::Position::CENTER) # 中央表示

		close_button = Gtk::Button.new("CLOSE")
		close_button.signal_connect("clicked"){ @dialog.destroy }
		@dialog.action_area.pack_start(close_button)

		label = Gtk::Label.new(info_message.to_s)
		@dialog.vbox.pack_start(label)

		@dialog.set_modal(true)
		@dialog.show_all
	end

	def input_dialog(input_message, ok_proc, cancle_proc)  # 入力表示ダイアログ
		@dialog = Gtk::Dialog.new() # ウィンドウ作成
		@dialog.set_window_position(Gtk::Window::Position::CENTER) # 中央表示

		ok_button = Gtk::Button.new("OK")
		ok_button.signal_connect("clicked"){ ok_proc.call(); @dialog.destroy }
		@dialog.action_area.pack_start(ok_button)

		cancel_button = Gtk::Button.new("CANCEL")
		cancel_button.signal_connect("clicked"){ cancle_proc.call(); @dialog.destroy }
		@dialog.action_area.pack_start(cancel_button)

		label = Gtk::Label.new(input_message)
		@dialog.vbox.pack_start(label)

		@dialog_entry = Gtk::Entry.new()
		@dialog_entry.signal_connect("activate"){ ok_proc.call(); @dialog.destroy }
		@dialog.vbox.pack_start(@dialog_entry)

		@dialog.set_modal(true)
		@dialog.show_all

	end

	# ファイル新規作成
	def file_new()
		if @change  # 変更済みならば
			yes_proc = proc do # YESの場合の処理
				file_save_as()
				file_new_exec()
			end
			no_proc = proc do  # NOの場合の処理
				file_new_exec()
			end
			cancel_proc = proc {}  # CANCELの場合の処理

			yes_no_cancel_dialog("ファイルは変更されています。\nファイルを保存しますか？",yes_proc, no_proc, cancel_proc)
		else         # 変更が無いなら
			file_new_exec()
		end
	end

	# ファイル開く
	def file_open()
p @change
p 1
		if @change  # 変更済みならば
			yes_proc = proc do # YESの場合の処理
				ok_proc = proc do # 保存でOKの場合
					@file_name = @save_dialog.get_filename
					file_save_as_exec()
					@save_dialog.destroy
					ok_proc = proc{ file_open_exec(); @open_dialog.destroy } # ファイルを開く場合の処理
					cancel_proc = proc{ @open_dialog.destroy }               # キャンセルした場合の処理
					file_open_selection(ok_proc, cancel_proc)
				end
				cancel_proc = proc do # 保存でCANCELの場合
					@save_dialog.destroy
				end
				file_save_selection(ok_proc, cancel_proc)
			end
			no_proc = proc do  # NOの場合の処理
				ok_proc = proc{ file_open_exec(); @open_dialog.destroy } # ファイルを開く場合の処理
				cancel_proc = proc{ @open_dialog.destroy }               # キャンセルした場合の処理
				file_open_selection(ok_proc, cancel_proc)
			end
			cancel_proc = proc {}  # CANCELの場合の処理

			yes_no_cancel_dialog("ファイルは変更されています。\nファイルを保存しますか？",yes_proc, no_proc, cancel_proc)
		else         # 変更が無いなら
			ok_proc = proc{ file_open_exec(); @open_dialog.destroy } # ファイルを開く場合の処理
			cancel_proc = proc{ @open_dialog.destroy }               # キャンセルした場合の処理
			file_open_selection(ok_proc, cancel_proc)
		end
	end

	def file_save() # ファイル保存
		if !(@file_name)   # ファイル名がなければ
			file_save_as()
			return
		end
		file_save_exec()
	end

	def file_save_as() # ファイル名前を付けて保存
		ok_proc = proc do
			@file_name = @save_dialog.get_filename
			file_save_as_exec()
		end
		cancel_proc = proc do 
			@save_dialog.destroy
		end
		file_save_selection(ok_proc, cancel_proc)
	end

	# ファイル保存して終了
	def file_save_quit()
		file_save()
		exit
	end

	# ファイル終了
	def file_quit()
		exit
	end

	def file_new_exec # 新規ファイルを実行
		@change = nil
		@file_name = nil
		@file_code = "EUC"
		@file_enter = "LF"
		@window.set_title("(無題) [#{@file_code}][#{@file_enter}] - #{Title}")
#		@text.delete_text(0, @text.length)
#		@text.delete_text(0, @text.get_length)
#		@text.delete_from_cursor(0, @text.get_length)
	end
	private :file_new_exec

	def file_open_exec() # ファイルを開くを実行
		@file_name = @open_dialog.get_filename

		string = nil
		begin
			open(@file_name) do |fh|
				string = fh.read
			end

			guess_code = Kconv::guess(string)  # 文字コード変換
			if guess_code = Kconv::EUC
				@file_code = "EUC"
			elsif guess_code = Kconv::SJIS
				@file_code = "SJIS"
				string = Kconv::toeuc(string)
			else
				raise("unknown charactor code")
			end

			if string =~ /\r\n/           # 改行コード変換
				@file_enter = "CR+LF"
			elsif string =~ /\r/
				@file_enter = "CR"
			else
				@file_enter = "LF"
			end

			@text.delete_text(0, @text.get_length)
			@text.insert_text(string, 0)
		rescue Errno::ENOENT                # ファイルがなかった場合は
			@file_code = "EUC"
			@file_enter = "LF"
			@text.delete_text(0, @text.get_length)
		end

		@change = nil
		@window.set_title("#{@file_name} [#{@file_code}][#{@file_enter}] - #{Title}")
	end
	private :file_open_exec

	def file_save_as_exec # ファイル名をつけて保存を実行
		@file_sel_code_menu_item.keys.each do |code|
			@file_code = code if @file_sel_code_menu_item[code] == @file_sel_code_menu.get_active
		end
		@file_sel_enter_menu_item.keys.each do |enter|
			@file_enter = enter if @file_sel_enter_menu_item[enter] == @file_sel_enter_menu.get_active
		end
		file_save_exec()
		@save_dialog.destroy
		@window.set_title("#{@file_name} [#{@file_code}][#{@file_enter}] - #{Title}")
	end
	private :file_save_as_exec

	def file_save_exec # ファイル保存実行
		save_data = @text.get_chars(0, @text.get_length)

		if @file_code == "EUC"
			save_data = Kconv::toeuc(save_data)
		elsif @file_code == "SJIS"
			save_data = Kconv::tosjis(save_data)
		else
			raise("Encode type failed")
		end

		if @file_enter == 'CR+LF'
			save_data = save_data.gsub(/\n/, "\r\n")
		elsif @file_enter == 'CR'
			save_data = save_data.gsub(/\n/, "\r")
		end

		open(@file_name, "w") do |fh| # ファイル保存
			fh.print save_data
		end
	end
	private :file_save_exec

	def file_open_selection(ok_proc, cancel_proc) # ファイル保存のFileSelection
		@open_dialog = Gtk::FileSelection.new("Open as ...")
		@open_dialog.set_window_position(Gtk::Window::Position::CENTER) # 中央表示
		@open_dialog.set_modal(true)

		@open_dialog.ok_button.signal_connect("clicked"){ ok_proc.call() }
		@open_dialog.cancel_button.signal_connect("clicked"){ cancel_proc.call() }

		@open_dialog.show_all
	end
	private :file_open_selection

	def file_save_selection(ok_proc, cancel_proc) # ファイル保存のFileSelection
		@save_dialog = Gtk::FileSelection.new("Save as ...")
#		@save_dialog.position(Gtk::WIN_POS_CENTER) # 中央表示
		@save_dialog.set_window_position(Gtk::Window::Position::CENTER) # 中央表示
		@save_dialog.set_modal(true)

		@save_dialog.ok_button.signal_connect("clicked"){ ok_proc.call() }
		@save_dialog.cancel_button.signal_connect("clicked"){ cancel_proc.call() }

		code_frame = Gtk::Frame.new("文字コード")               # 文字コード
		@save_dialog.action_area.pack_start(code_frame)

		option_menu = Gtk::OptionMenu.new()               # オプションメニュー
		code_frame.add(option_menu)

		@file_sel_code_menu = Gtk::Menu.new
		option_menu.set_menu(@file_sel_code_menu)

		group = nil
		@file_sel_code_menu_item = {}
		Codes.each do |code|               # メニューアイテム（文字コード）
			@file_sel_code_menu_item[code] = Gtk::RadioMenuItem.new(group, code)
			group = @file_sel_code_menu_item[code].group
			@file_sel_code_menu_item[code].set_active(true) if @file_code == code
			@file_sel_code_menu.append(@file_sel_code_menu_item[code])
		end

		Codes.each_index do |i|           # デフォルト選択文字コード
			option_menu.set_history(i) if @file_code == Codes[i]
		end

		enter_frame = Gtk::Frame.new("改行コード")               # 改行コード
		@save_dialog.action_area.pack_start(enter_frame)

		option_menu = Gtk::OptionMenu.new()               # オプションメニュー
		enter_frame.add(option_menu)

		@file_sel_enter_menu = Gtk::Menu.new
		option_menu.set_menu(@file_sel_enter_menu)

		group = nil
		@file_sel_enter_menu_item = {}
		Enters.each do |enter|               # メニューアイテム（文字コード）
			@file_sel_enter_menu_item[enter] = Gtk::RadioMenuItem.new(group, enter)
			group = @file_sel_enter_menu_item[enter].group
			@file_sel_enter_menu_item[enter].set_active(true) if @file_enter == enter
			@file_sel_enter_menu.append(@file_sel_enter_menu_item[enter])
		end

		Enters.each_index do |i|           # デフォルト選択文字コード
			option_menu.set_history(i) if @file_enter == Enters[i]
		end

		@save_dialog.show_all
	end
	private :file_save_selection


	# 編集 -> カット
	def edit_cut()
		@text.cut_clipboard()
	end

	# 編集 -> コピー
	def edit_copy()
		@text.copy_clipboard()
	end

	# 編集 -> ペースト
	def edit_paste()
		@text.paste_clipboard()
	end

	# 編集 -> すべて選択
	def edit_all_select()
		@text.select_region(0, @text.get_length)
	end

	# 編集 -> 位置標示
	def edit_show_position()
		current_text = @text.get_chars(0, @text.position)
		splited_current_text = current_text.split(/\n/)
		if splited_current_text == []
			x = 0
			y = 0
		else
			y = splited_current_text.length - 1
			x = splited_current_text[y].length
		end
		info_dialog("X=#{x+1}\nY=#{y+y}")
	end

	# 編集 -> ジャンプ
	def edit_jump()
		ok_proc = proc do 
			jump_line = Integer(@dialog_input.get_text)
			if jump_line
				@text.set_position(0)
			else
				all_text = @text.get_chars(0, @text.get_length)
				

				jump_line.split(/\n/, jump_line)
				@text.set_position(0)
			end
		end
		cancel_proc = proc {}
		input_dialog("行番号", ok_proc, cancel_proc)
	end

	# 検索
	def search()
		@search_dialog = Gtk::Window.new()
		@search_dialog.set_window_position(Gtk::Window::Position::CENTER) # 中央表示
		@search_dialog.set_modal(true)

		table = Gtk::Table.new(3,4)
		table.set_row_spacings(5)
		table.set_col_spacings(5)
		@search_dialog.add(table)

		label = Gtk::Label.new("検索文字")
		table.attach(label, 1, 2, 1, 2)

		@search_key = Gtk::Entry.new()
		@search_key.grab_focus
		@search_key.signal_connect("activate"){ search_exec() }
		table.attach(@search_key, 2, 3, 1, 2)

		down_button = Gtk::Button.new("検索")
		down_button.signal_connect("clicked"){ search_exec() }
		table.attach(down_button, 1, 3, 2, 3)

		close_button = Gtk::Button.new("閉じる")
		close_button.signal_connect("clicked"){ @search_dialog.destroy; @text.grab_focus }
		table.attach(close_button, 1, 3, 3, 4)

		@search_dialog.show_all
	end

	def search_exec()
		current_position = @text.position

		text_end_position = @text.get_length
		all_text = @text.get_chars(0, text_end_position)
		search_key = @search_key.get_text

		searched_position = all_text.index(/#{search_key}/e, current_position)
		searched_text = $&

		if searched_position             # 文字列が見つかったなら
			@text.position = searched_position + 1
			@text.select_region(searched_position, searched_position + searched_text.length)
		end
	end

	def initialize
		# ウィジェット作成
		@window = Gtk::Window.new(Gtk::Window::TOPLEVEL) # ウィンドウ作成
		@window.set_window_position(Gtk::Window::Position::CENTER) # 中央表示
		@window.set_default_size(500,300)

		@window.signal_connect('delete_event') do # 終了イベント
			file_quit() # 終了
		end

		# VBox
		vbox = Gtk::VBox.new(false, 0)
		@window.add(vbox)

		# HandleBox
		handlebox = Gtk::HandleBox.new()
		vbox.pack_start(handlebox, false, false)

		# menubarの作成
		menubar = Gtk::MenuBar.new()
		handlebox.add(menubar)

		# ゲームニュー
		file_item = Gtk::MenuItem.new("ファイル")
		menubar.append(file_item)

		file_menu = Gtk::Menu.new()
		file_item.set_submenu(file_menu)

		# ファイル -> 新規作成
		file_new_item = Gtk::MenuItem.new("新規作成")
		file_menu.append(file_new_item)
		file_new_item.signal_connect("activate") { file_new() }

		# ファイル -> 開く
		file_open_item = Gtk::MenuItem.new("開く ...")
		file_menu.append(file_open_item)
		file_open_item.signal_connect("activate") { file_open() }

		# ファイル -> 上書き保存
		file_save_item = Gtk::MenuItem::new("上書き保存")
		file_menu.append(file_save_item)
		file_save_item.signal_connect("activate") { file_save() }

		# ファイル -> 別名で保存
		file_save_as_item = Gtk::MenuItem.new("別名で保存 ...")
		file_menu.append(file_save_as_item)
		file_save_as_item.signal_connect("activate") { file_save_as() }

		# ファイル -> セパレータ
		file_sep_item = Gtk::MenuItem.new()
		file_menu.append(file_sep_item)

		# ファイル -> 保存して終了
		file_save_quit_item = Gtk::MenuItem.new("保存して終了")
		file_menu.append(file_save_quit_item)
		file_save_quit_item.signal_connect("activate") { file_save_quit() }

		# ファイル -> 終了
		file_quit_item = Gtk::MenuItem.new("終了")
		file_menu.append(file_quit_item)
		file_quit_item.signal_connect("activate") { file_quit() }

		# 編集
		edit_item = Gtk::MenuItem.new("編集")
		menubar.append(edit_item)

		edit_menu = Gtk::Menu.new
		edit_item.set_submenu(edit_menu)

		# 編集 -> カット
		edit_cut_item = Gtk::MenuItem.new("カット")
		edit_menu.append(edit_cut_item)
		edit_cut_item.signal_connect("activate") { edit_cut() }

		# 編集 -> コピー
		edit_copy_item = Gtk::MenuItem.new("コピー")
		edit_menu.append(edit_copy_item)
		edit_copy_item.signal_connect("activate") { edit_copy() }

		# 編集 -> ペースト
		edit_paste_item = Gtk::MenuItem.new("ペースト")
		edit_menu.append(edit_paste_item)
		edit_paste_item.signal_connect("activate") { edit_paste() }

		# 編集 -> セパレータ
		edit_sep = Gtk::MenuItem.new()
		edit_menu.append(edit_sep)

		# 編集 -> すべて選択
		edit_allselect_item = Gtk::MenuItem.new("すべて選択")
		edit_menu.append(edit_allselect_item)
		edit_allselect_item.signal_connect("activate") { edit_all_select() }

		# 編集 -> 位置標示
		edit_position_item = Gtk::MenuItem.new("位置標示")
		edit_menu.append(edit_position_item)
		edit_position_item.signal_connect("activate") { edit_show_position() }

		# 編集 -> ジャンプ
		edit_position_item = Gtk::MenuItem.new("ジャンプ")
		edit_menu.append(edit_position_item)
		edit_position_item.signal_connect("activate") { edit_jump() }


		# 検索
		search_item = Gtk::MenuItem.new("検索")
		menubar.append(search_item)

		search_menu = Gtk::Menu.new
		search_item.set_submenu(search_menu)

		# 検索 -> 検索
		search_search_item = Gtk::MenuItem.new("検索")
		search_menu.append(search_search_item)
		search_search_item.signal_connect("activate") { search() }


		# ヘルプメニュー
		help_item = Gtk::MenuItem.new("ヘルプ")
#		help_item.right_justify # 右寄せ
		help_item.set_right_justified(true) # 右寄せ
		menubar.append(help_item)

		help_menu = Gtk::Menu.new
		help_item.set_submenu(help_menu)

		# ヘルプ -> このエディタについて
		help_about_item = Gtk::MenuItem.new("このエディタについて")
		help_menu.append(help_about_item)
		help_about_item.signal_connect("activate") { info_dialog("Ruby/GTK Editor") }


		# スクロールウィンドウ
		scwin = Gtk::ScrolledWindow.new
		scwin.border_width = 5
		scwin.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_ALWAYS)
		vbox.pack_start(scwin)

		# テキスト
#		@text = Gtk::Text.new
		@text = Gtk::TextView.new
		scwin.add(@text)
		@text.set_editable(true)
		@text.grab_focus
#		@text.signal_connect("changed"){ @change = true; p "changed" }

		@window.show_all

		file_new_exec()  # 新規ファイル

	end
end

Editor.new()
Gtk.main # Gtkのループに入る

