class OriginalFileSelection < Gtk::Window
	def initialize
		super(Gtk::WINDOW_DIALOG)

		table = Gtk::Table.new(2, 3)
		add(table)

		sw = Gtk::ScrolledWindow.new()
		sw.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
		sw.set_usize(200, 200)
		table.attach(sw, 0, 2, 0, 1)

		@clist = Gtk::CList.new(["Name", "Size", "Mode"])        # եCList
		@clist.set_column_justification(1, Gtk::JUSTIFY_RIGHT)
		@clist.set_column_width(0, 90)
		@clist.set_column_width(1, 40)

		sw.add_with_viewport(@clist)

		@action_area = Gtk::HBox.new()               # action_area
		table.attach(@action_area, 0, 2, 1, 2)

		@label = Gtk::Label.new("")                  # ߤΥǥ쥯ȥɽ
		table.attach(@label, 0, 2, 2, 3)

		@entry = Gtk::Entry.new                      # ȥ꡼
		table.attach(@entry, 0, 2, 3, 4)

		@ok_button = Gtk::Button.new("OK")           # OKܥ
		table.attach(@ok_button, 0, 1, 4, 5)

		@cancel_button = Gtk::Button.new("CANCEL")   # CANCELܥ
		table.attach(@cancel_button, 1, 2, 4, 5)

		@clist.signal_connect("select_row") do |widget, row, column, event|  # CList
			if @file_list[row]["dir"]
				@current_dir = File.expand_path(@file_list[row]["name"], @current_dir)
				change_dir()
			else
				@entry.set_text(@file_list[row]["name"])
			end
		end

		@clist.signal_connect("click_column") do |widget, column|  # Ƚѹ
			@clist.freeze
			if @sort_key == column
				if @sort_updown
					@sort_updown = false
				else
					@sort_updown = true
				end
			else
				@sort_key = column
			end
			print_file_list()  # եꥹȺɽ
			@clist.thaw
		end

		# ե
		@sort_key = 0
		@sort_updown = true

		@current_dir = Dir.pwd
		change_dir()
	end


	def action_area
		@action_area
	end

	def cancel_button
		@cancel_button
	end
	
	def ok_button
		@ok_button
	end
	
	def get_filename
		@current_dir + File::Separator + @entry.get_text
	end
	
	def set_filename(filename)
		@current_dir, file = File.split(filename)
		@entry.set_text(file)
	end


	private
	def make_file_list() # եΰ
		@file_list = []
		count = 0
		Dir.foreach(@current_dir) do |file|
			full_file = @current_dir + File::Separator + file

			begin
				dir = FileTest.directory?(full_file)
				file_stat = File.stat(full_file)
				v0, a0 = file_stat.mode.divmod(8) 
				v1, a1 = v0.divmod(8)
				v2, a2 = v1.divmod(8)
				@file_list[count] = {
					'name' => file,
					'size' => file_stat.size.to_s,
					'dir' => dir,
					'mode' => "#{a2}#{a1}#{a0}",
				}
				count += 1
			rescue
			end
		end
	end

	def print_file_list() # եCListɽ
		@clist.clear()

		@file_list = @file_list.sort do |file_a, file_b| # 
			if @sort_key == 0
				if @sort_updown
					file_a["name"] <=> file_b["name"]
				else
					file_b["name"] <=> file_a["name"]
				end
			elsif @sort_key == 1
				if @sort_updown
					Integer(file_a["size"]) <=> Integer(file_b["size"])
				else
					Integer(file_b["size"]) <=> Integer(file_a["size"])
				end
			elsif @sort_key == 2
				if @sort_updown
					file_a["mode"] <=> file_b["mode"]
				else
					file_b["mode"] <=> file_a["mode"]
				end
			end
		end

		@file_list.each do |file_detail|  # եCListɽ
			if file_detail["dir"]          # ǥ쥯ȥʤ
				@clist.append([file_detail["name"], file_detail["size"], "Dir"])
			else
				@clist.append([file_detail["name"], file_detail["size"], file_detail["mode"]])
			end
		end
		@clist.thaw
	end

	def change_dir()
		@clist.freeze
		@label.set_text("Current Dir: #{@current_dir}")
		make_file_list()  # եꥹȥǡ
		print_file_list() # եꥹȤɽ
		@entry.set_text("")
		@clist.thaw
	end
end
