#!/usr/local/bin/ruby -Ku

require "gtk2"
Gtk.init

window = Gtk::Window.new()                # ウィンドウ作成
window.signal_connect("destroy") do       # "destroy"シグナル
	Gtk::main_quit                          # 終了
end

vbox = Gtk::VBox.new()                    # VBoxの作成

[                                         # ボタン文字の配列
  ["left top", "center top", "right top"],
  ["left bottom", "center bottom", "right bottom"]
].each do |row|
	hbox = Gtk::HBox.new()                  # HBoxの作成
	vbox.pack_start(hbox)                   # VBoxにHBoxを追加
	row.each do |label_name|
		button = Gtk::Button.new(label_name)  # Button作成
		hbox.pack_start(button)               # HBoxにボタンを追加
	end
end

window.add(vbox)                           # ウィンドウにHBoxを追加
window.show_all                           # ウィジェットを表示

Gtk.main                                  # GTK+のループに入る
