#!/usr/local/bin/ruby -Ku

=begin
GTK2CListがなくなって、代わりにListStoreを使うようになったので、大幅な変更あり
Ruby/GTK2のサンプルプログラムを参考にしています

リストタイトル部分には、column1とcolumn2
=end

require "gtk2"
Gtk.init

window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント

# 大元のウィジェット作成
# このときに、データ部分に入れる、データ型を定義しておく
# この場合は、2列で、文字列と整数
model = Gtk::ListStore.new(String, String) 

# タイトル部分を作成
treeview = Gtk::TreeView.new(model) # create tree view

["column1", "column2"].each_with_index do |title, i|
	renderer = Gtk::CellRendererText.new
	# 第1引数は、タイトル名、第2引数は、CellRendererText、第3引数は、表示位置などのオプション
	column = Gtk::TreeViewColumn.new(title, renderer, 'text' => i)
	column.set_sort_column_id(i)
	treeview.append_column(column)
end

window.add(treeview)

#clist = Gtk::CList.new(["column1", "column2"])
#window.add(clist)

window.show_all

Gtk.main
