#!/usr/local/bin/ruby -Ku

=begin
GTK2CListがなくなって、代わりにListStoreを使うようになったので、大幅な変更あり
Ruby/GTK2のサンプルプログラムを参考にしています
=end

require "gtk2"
Gtk.init

window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント

box = Gtk::VBox.new()
window.add(box)


# 大元のウィジェット作成
# このときに、データ部分に入れる、データ型を定義しておく
# この場合は、2列で、文字列と文字列と整数
model = Gtk::ListStore.new(String, String, Integer) 

# タイトル部分を作成
$treeview = Gtk::TreeView.new(model) # create tree view

["column1", "column2", "column3"].each_with_index do |title, i|
	renderer = Gtk::CellRendererText.new
	# 第1引数は、タイトル名、第2引数は、CellRendererText、第3引数は、表示位置などのオプション
	column = Gtk::TreeViewColumn.new(title, renderer, 'text' => i)
	column.set_sort_column_id(i)
	$treeview.append_column(column)
end

# データ部分を作成
(0..9).each do |line|
	iter = model.append
	iter.set_value(0, "cat#{line}")
	iter.set_value(1, "dog#{line}")
	iter.set_value(2, line) # ListStoreインスタンス生成時にIntegerを指定していれば、整数なども入る
end

$treeview.selection.set_mode( Gtk::SELECTION_EXTENDED )

box.pack_start($treeview)


button = Gtk::Button.new("BUTTON")
button.signal_connect("clicked") do
	selected = false
	$treeview.selection.selected_each do|model, path, iter|
		selected = true

		puts iter.get_value(0)
		puts iter.get_value(1)
		puts iter.get_value(2)

#		p model
#		p path
#		p iter
	end

	puts "not selected" if selected == false
end
box.pack_start(button)



window.show_all

Gtk.main



#box = Gtk::VBox.new()
#window.add(box)

#$clist = Gtk::CList.new(["column1", "column2", "column3"])
#box.pack_start($clist)

#$clist.set_selection_mode( Gtk::SELECTION_EXTENDED )

#pline = []
#(0..9).each do |line|
#	pline[line] = $clist.append(["cat#{line}", "dog#{line}", "fish#{line}"])
#end
#
#button =Gtk::Button.new("BUTTON")
#button.signal_connect("clicked") do
#	$clist.each_selection do |i|
#		print "selected line number is #{i}\n"
#	end
#end
#box.pack_start(button)

