#!/usr/local/bin/ruby -Ku

=begin
元はなかったけれど、ちょっとついでで作成してみた
ScroolWindowを付けて、大量出力にして、ボタンを付けて、ボタンを押すと再描画する
=end

require "gtk2"
Gtk.init

def add_rows(model)
	# データ部分を作成
	(0..3000).each do |line|
		iter = $model.append
		iter.set_value(0, "cat#{line}")
		iter.set_value(1, "dog#{line}")
		iter.set_value(2, line) # ListStoreインスタンス生成時にIntegerを指定していれば、整数なども入る
		iter.set_value(3, rand(10000))
	end
end


window = Gtk::Window.new() # ウィンドウ作成
window.signal_connect('delete_event'){ Gtk::main_quit } # 終了イベント

box = Gtk::VBox.new()
window.add(box)

sw = Gtk::ScrolledWindow.new()
sw.set_size_request(200, 200)
box.add(sw)

# 大元のウィジェット作成
# このときに、データ部分に入れる、データ型を定義しておく
# この場合は、2列で、文字列と文字列と整数
$model = Gtk::ListStore.new(String, String, Integer, Integer, TrueClass) 

# タイトル部分を作成
$treeview = Gtk::TreeView.new($model) # create tree view

["column1", "column2", "column3", "column4"].each_with_index do |title, i|
	renderer = Gtk::CellRendererText.new
	# 第1引数は、タイトル名、第2引数は、CellRendererText、第3引数は、表示位置などのオプション
	column = Gtk::TreeViewColumn.new(title, renderer, {'text' => i})
#	column.set_sort_column_id(i)    # ソート可能にしておくと、トグルボタンで、情報を取れなくなる
	$treeview.append_column(column)
end

#5つ目のタイトル部分
renderer = Gtk::CellRendererToggle.new
renderer.signal_connect("toggled") do |widget, str|
	# ソートされていなければ、strと番号が一致する
	p "toggle #{widget.inspect} #{str.inspect}"
	p "#{widget.activatable?}"
	p "#{widget.active?}"
	p "#{widget.inconsistent?}"
	p "#{widget.radio?}"
end
# 第1引数は、タイトル名、第2引数は、CellRendererText、第3引数は、表示位置などのオプション
column = Gtk::TreeViewColumn.new("column5", renderer, {'active' => 4})
$treeview.append_column(column)

add_rows($model) # データ部分を作成

sw.add($treeview)

# ボタン
button = Gtk::Button.new("BUTTON")
button.signal_connect("clicked") do
	$model.clear
	add_rows($model) # データ部分を作成
end
box.pack_start(button)


window.show_all
Gtk.main



