#!/usr/local/bin/ruby -Ke

require 'gtk' # gtkθƽ

window = Gtk::Window.new()
window.signal_connect('delete_event'){ Gtk::main_quit } # λ٥

drawing_area = Gtk::DrawingArea.new()  # ɥꥢκ
drawing_area.set_usize(30, 30)  # ɥꥢ礭
window.add(drawing_area)

drawing_area.signal_connect("configure_event") do |drawing_area, event|
	# ԥޥåפ
	$pixmap = nil if $pixmap
	$pixmap = Gdk::Pixmap.new(drawing_area.window,
		drawing_area.allocation.width, drawing_area.allocation.height, -1)

	gc = Gdk::GC.new($pixmap)  # GC
	colormap = Gdk::Colormap.get_system()  # 顼ޥåפμФ

	# ɥ֥ߤͤ
	width = drawing_area.allocation.width
	height = drawing_area.allocation.height

	(0..width-1).each do |x|
		(0..height-1).each do |y|
			r = 0xffff * (x.to_f / width)
			g = 0xffff * (y.to_f / height)
			b = 0xffff
			color = Gdk::Color.new(r, g, b)
			colormap.alloc_color(color, nil, true) # color˥顼ޥåפ
			gc.set_foreground(color)  # GCΥե饦ɤcolor
			$pixmap.draw_point(gc, x, y) # 
		end
	end
	gc.destroy # GC˴
end

drawing_area.signal_connect("expose_event") do |drawing_area, event| # 
	drawable = drawing_area.window  # ɥ֥Ф
	gc = Gdk::GC.new(drawable)  # GC

	# ԥޥåפɥ֥˥ԡ
	drawable.draw_pixmap(gc, $pixmap, event.area.x, event.area.y, 
		event.area.x, event.area.y, event.area.width, event.area.height)

	gc.destroy # GC˴
end

window.show_all
Gtk.main

