#!/usr/local/bin/ruby -Ku

require "gtk2"
Gtk.init

class MineSweep
	Face_arr1 = [
		"16 16 4 1",
		" 	c None",
		".	c #000000",
		"X	c #FFFF00",
		"r	c #AA0000",
		"     ......     ",
		"   ..XXXXXX..   ",
		" ..XXXXXXXXXX.. ",
		" .XXXXXXXXXXXX. ",
		" .XX..XXXX..XX. ",
		".XXX..XXXX..XXX.",
		".XXXXXXXXXXXXXX.",
		".XXXXXXXXXXXXXX.",
		".XXXXXXXXXXXXXX.",
		".XXXXXXXXXXXXXX.",
		" .XX.XXXXXX.XX. ",
		" .XXX......XXX. ",
		"  .XXXXXXXXXX.  ",
		"   ..XXXXXX..   ",
		"     ......     ",
		"                ",
	]

	Face_arr2 = [
		"16 16 4 1",
		"       c None",
		".      c #000000",
		"X      c #FFFF00",
		"r      c #AA0000",
		"     ......     ",
		"   ..XXXXXX..   ",
		" ..XXXXXXXXXX.. ",
		" .XXXXXXXXXXXX. ",
		" .XX.X.XX.X.XX. ",
		".XXXX.XXXX.XXXX.",
		".XXX.X.XX.X.XXX.",
		".XXXXXXXXXXXXXX.",
		".XXXXXXXXXXXXXX.",
		".XXXXXXXXXXXXXX.",
		" .XXX......XXX. ",
		" .XX.XXXXXX.XX. ",
		"  .XXXXXXXXXX.  ",
		"   ..XXXXXX..   ",
		"     ......     ",
		"                ",
	]

	Face_arr3 = [
		"16 16 4 1",
		"       c None",
		".      c #000000",
		"X      c #FFFF00",
		"r      c #AA0000",
		"     ......     ",
		"   ..XXXXXX..   ",
		" ..XXXXXXXXXX.. ",
		" .XXXXXXXXXXXX. ",
		" .XX...XX...XX. ",
		".XX..........XX.",
		".X.X...XX...X.X.",
		"..XXXXXXXXXXXX..",
		".XXXXXXXXXXXXXX.",
		".XXXXXXXXXXXXXX.",
		" .XX.XXXXXX.XX. ",
		" .XXX......XXX. ",
		"  .XXXXXXXXXX.  ",
		"   ..XXXXXX..   ",
		"     ......     ",
		"                ",
	]

	class Board
		# Boardオブジェクト作成し、ウィジェットも作成する
		def initialize(parent_widget, timer_widget, laugh_widget, rest_widget, board_width, board_height, mine_num, face)
			if mine_num > (board_width * board_height) / 2
				raise ("A number of mine is too many!")
			end

			@board_data = []
			@width = board_width
			@height = board_height
			@face = face

			@first_open = nil
			@timer = 0
			@timeout_tag = nil

			# ウィジェット処理
			@parent_widget = parent_widget

			@time_label = timer_widget   # 時間ボタン
			@laugh_button = laugh_widget # にこちゃんマーク
			@rest_label = rest_widget    # 後いくつマーク

			@rest_label.set_text(sprintf("%04d", mine_num))

			# マスを入れるテーブル
			@board_table = Gtk::Table.new(@width, @height, false)
			@parent_widget.add(@board_table)

			# マスのウィジェットとデータの作成
			for x in (0 .. @width-1)
				@board_data[x] = []
				for y in (0 .. @height-1)
					@board_data[x][y] = {}

					@board_data[x][y]["mine"] = nil # 地雷があるか
					@board_data[x][y]["status"] = "" # 旗の状態
					@board_data[x][y]["count"] = 0 # 周りに何個あるか（oの時のみ有効）

					# マスにボタンを配置
					@board_data[x][y]["button_widget"] = Gtk::ToggleButton.new(" ")
					#@board_data[x][y]["button_widget"].set_usize(20,20)
					@board_data[x][y]["button_widget"].set_size_request(20,20)
					@board_table.attach(@board_data[x][y]["button_widget"], x, x+1, y, y+1)

					# クリックイベント
					@board_data[x][y]["button_widget"].signal_connect("clicked") do |widget|
						for y in (0 .. @height-1)
							for x in (0 .. @width-1)
								if widget == @board_data[x][y]["button_widget"]
									xx = x
									yy = y
								end
							end
						end
						open(xx, yy)
					end

					# ボタンプレスイベント
					@board_data[x][y]["button_widget"].signal_connect("button_press_event") do|widget, event|
						for y in (0 .. @height-1)
							for x in (0 .. @width-1)
								if widget == @board_data[x][y]["button_widget"]
									xx = x
									yy = y
								end
							end
						end
						if event.button == 3  # 右クリックなら
							mark(xx, yy)
						elsif event.button == 2  # 中クリックなら
							check(xx, yy)
						end
					end
				end
			end

			# 地雷設置
			(0..mine_num-1).each do |i|
				loop do
					x = rand() * @width
					y = rand() * @height
					if @board_data[x][y]["mine"] == nil
						@board_data[x][y]["mine"] = true
						break
					end
				end
			end

			@parent_widget.show_all
		end

		def remove()
			Gtk.timeout_remove(@timeout_tag) if @timeout_tag

			@parent_widget.remove(@board_table)
		end

		def open(x, y)
			@board_data[x][y]["button_widget"].set_active(true)
			return() if @board_data[x][y]["status"] == "o"

			if !@first_open # 初めて開いたならタイマースタート
				@time_label.set_text("0000")
				@timeout_tag = Gtk.timeout_add(1000) do
					@timer += 1
					@time_label.set_text(sprintf("%04d", @timer))
					true
				end
				@first_open = true
			end

			if @board_data[x][y]["mine"] == true # 地雷を踏んだ！！
				@board_data[x][y]["button_widget"].child.set_text("x")
				Gtk.timeout_remove(@timeout_tag)

#				pm = Gtk::Pixmap.new(@face[1][0], @face[1][1])
				pm = Gtk::Image.new(@face[1][0], @face[1][1])
				pm.show
				@laugh_button.remove(@laugh_button.child())
				@laugh_button.add(pm)

				@game_status = "ouch"
				nosensitivate_all_widget()
			else
				@board_data[x][y]["status"] = "o"
				@board_data[x][y]["count"] = check_count_mine(x, y)
				@board_data[x][y]["button_widget"].child.set_text(@board_data[x][y]["count"].to_s)

				check_complete()
			end
		end

		def mark(x, y)
			case @board_data[x][y]["status"]
				when ""
					@board_data[x][y]["status"] = "m"
					@board_data[x][y]["button_widget"].child.set_text("*")
					@board_data[x][y]["button_widget"].set_active(false)
#					@rest_label.set_text(sprintf("%04d", @rest_label.get_text.to_i - 1))
					@rest_label.set_text(sprintf("%04d", @rest_label.text.to_i - 1))
					check_complete()
				when "m"
					@board_data[x][y]["status"] = "q"
					@board_data[x][y]["button_widget"].child.set_text("?")
					@board_data[x][y]["button_widget"].set_active(false)
#					@rest_label.set_text(sprintf("%04d", @rest_label.get_text.to_i + 1))
					@rest_label.set_text(sprintf("%04d", @rest_label.text.to_i + 1))
				when "q"
					@board_data[x][y]["status"] = ""
					@board_data[x][y]["button_widget"].child.set_text("")
					@board_data[x][y]["button_widget"].set_active(false)
			end
		end

		def check(x, y)
			return() if @board_data[x][y]["status"] != "o"

			temp_table = []
			for i in (0 .. @width-1)
				temp_table[i] = []
			end

			xx = x
			yy = y
			marked_count, closed_list = check_count_flag(xx, yy)
			if @board_data[xx][yy]["count"] <= marked_count
				closed_list.each do |arr|
					open(arr[0], arr[1])
				end
			end
		end

		# すべてのウィジェットを押せなくする
		def nosensitivate_all_widget()
			for y in (0 .. @height-1)
				for x in (0 .. @width-1)
					@board_data[x][y]["button_widget"].set_sensitive(false)
				end
			end
		end

		# 完了したかどうかをチェック
		def check_complete()
#			return() if @rest_label.get_text.to_i != 0
			return() if @rest_label.text.to_i != 0
			for y in (0 .. @height-1)
				for x in (0 .. @width-1)
					return() if @board_data[x][y]['status'] != "m" && @board_data[x][y]['status'] != "o"
				end
			end
			Gtk.timeout_remove(@timeout_tag)
#			pm = Gtk::Pixmap.new(@face[2][0], @face[2][1])
			pm = Gtk::Image.new(@face[2][0], @face[2][1])
			pm.show
			@laugh_button.remove(@laugh_button.child())
			@laugh_button.add(pm)

			nosensitivate_all_widget()
		end

		# 周りのマークしてある数を数える
		def check_count_flag(x, y)
			closed_list = []
			count = 0
			(x-1 .. x+1).each do |xx|
				next if xx < 0 || xx > @width - 1
				(y-1 .. y+1).each do |yy|
					next if yy < 0 || yy > @height - 1
					next if x == xx && y == yy
					if @board_data[xx][yy]['status'] == "m"
						count += 1
					else
						closed_list.push([xx, yy])
					end
				end
			end
			[count, closed_list]
		end
		private :check_count_flag

		# 開いたときの周りの爆弾の数を数える
		def check_count_mine(x, y)
			count = 0
			(x-1 .. x+1).each do |xx|
				next if xx < 0 || xx > @width - 1
				(y-1 .. y+1).each do |yy|
					next if yy < 0 || yy > @height - 1
					next if x == xx && y == yy
					next if @board_data[xx][yy]['mine'] != true
					count += 1
				end
			end
			count
		end
		private :check_count_mine
	end


	def initialize
		# マスの数
		@board_width = 9
		@board_height = 9
		@board_mine_num = 10

		@cbs_show = false

		# ウィジェット作成
#		@window = Gtk::Window.new(Gtk::WINDOW_TOPLEVEL) # ウィンドウ作成
		@window = Gtk::Window.new( Gtk::Window::TOPLEVEL ) # ウィンドウ作成
		@window.set_title("Mine Sweep") # タイトルを付ける
		@window.signal_connect('delete_event'){ quit() } # 終了イベント
		@window.realize  # ウィンドウの実体化

		# 顔のピックスマップ作成
		face1_pix, face1_mask = Gdk::Pixmap.create_from_xpm_d(@window.window, nil, Face_arr1)
		face2_pix, face2_mask = Gdk::Pixmap.create_from_xpm_d(@window.window, nil, Face_arr2)
		face3_pix, face3_mask = Gdk::Pixmap.create_from_xpm_d(@window.window, nil, Face_arr3)
		@face = [[face1_pix, face1_mask], [face2_pix, face2_mask], [face3_pix, face3_mask]]

		vbox = Gtk::VBox.new(false, 0)
		@window.add(vbox)

		# menubarの作成
		menubar = Gtk::MenuBar.new()
		vbox.pack_start(menubar, false, false)

		# ゲームニュー
		game_item = Gtk::MenuItem.new("Game")
		menubar.append(game_item)

		game_menu = Gtk::Menu.new()
		game_item.set_submenu(game_menu)

		# ゲーム -> スタート
		game_start_item = Gtk::MenuItem.new("Start")
		game_menu.append(game_start_item)
		game_start_item.signal_connect("activate") { renew() }

		# ゲーム -> 盤面の変更
		game_chg_board_item = Gtk::MenuItem.new("Change Board Size")
		game_menu.append(game_chg_board_item)
		game_chg_board_item.signal_connect("activate") { change_board_size() }

		# ゲーム -> セパレータ
		game_sep = Gtk::MenuItem::new()
		game_menu.append(game_sep)

		# ゲーム -> 終了
		game_quit_item = Gtk::MenuItem.new("Quit")
		game_menu.append(game_quit_item)
		game_quit_item.signal_connect("activate") { quit() }


		# フレームとその中
		info_frame = Gtk::Frame.new("Game Info")
		vbox.pack_start(info_frame)

		info_hbox = Gtk::HBox.new()
		info_frame.add(info_hbox)

		# 時間ボタン
		@time_label = Gtk::Label.new("TIME")
		info_hbox.pack_start(@time_label)

		# にこちゃんマーク
		@laugh_button = Gtk::Button.new()
#		pm = Gtk::Pixmap.new(@face[0][0], @face[0][1])
		pm = Gtk::Image.new(@face[0][0], @face[0][1])
		@laugh_button.add(pm)
		info_hbox.pack_start(@laugh_button)
		@laugh_button.signal_connect("clicked") { renew() } # ニコニコマークをクリック
		tooptip = Gtk::Tooltips.new()
		tooptip.set_tip(@laugh_button, "Restart", nil)

		# 後いくつマーク
		@rest_label = Gtk::Label.new("REST")
		info_hbox.pack_start(@rest_label)

		# ゲームボード
		@game_frame = Gtk::Frame.new("Board")
		vbox.pack_start(@game_frame)

		# Boardオブジェクト作成し、ウィジェットも作成させる
		@board = Board.new(@game_frame, @time_label, @laugh_button, @rest_label,
		 @board_width, @board_height, @board_mine_num, @face)

		@window.show_all
	end

	def renew()
#		pm = Gtk::Pixmap.new(@face[0][0], @face[0][1])
		pm = Gtk::Image.new(@face[0][0], @face[0][1])
		pm.show
		@laugh_button.remove(@laugh_button.child())
		@laugh_button.add(pm)

		@time_label.set_text("TIME")
		@rest_label.set_text("REST")

		# Boardオブジェクトを初期化
		@board.remove()
		
		# Boardオブジェクト作成し、ウィジェットも作成させる
		@board = Board.new(@game_frame, @time_label, @laugh_button, @rest_label,
		 @board_width, @board_height, @board_mine_num, @face)
	end

	def quit()
		Gtk::main_quit
	end

	# 盤面の変更
	def change_board_size
#		@cbs_window = Gtk::Window.new(Gtk::WINDOW_DIALOG) # ウィンドウ作成
		@cbs_window = Gtk::Window.new(Gtk::Window::Type::POPUP) # ウィンドウ作成
		@cbs_window.set_title("Change Board Size") # タイトルを付ける
#		@cbs_window.position(Gtk::WIN_POS_CENTER) # 中央表示
		@cbs_window.set_window_position(Gtk::Window::Position::CENTER) # 中央表示
		@cbs_window.set_default_size(200,100)
		@cbs_window.signal_connect('delete_event'){ @cbs_show = false } # 終了イベント
		@cbs_window.set_modal(true)

		cbs_box = Gtk::VBox.new()
		@cbs_window.add(cbs_box)

		# Input
		cbs_frame = Gtk::Frame.new("Input")
		cbs_box.pack_start(cbs_frame)

		cbs_table = Gtk::Table.new(2, 4)
		cbs_frame.add(cbs_table)

		# Xの入力
		cbs_label1 = Gtk::Label.new("X:")
		cbs_table.attach(cbs_label1, 0, 1, 0, 1)

		cbs_adj1 = Gtk::Adjustment.new(@board_width, 5, 30, 1, 5, 0)
		@cbs_entry1 = Gtk::SpinButton.new(cbs_adj1, 0, 0)
		cbs_table.attach(@cbs_entry1, 1, 2, 0, 1)

		# Yの入力
		cbs_label2 = Gtk::Label.new("Y:")
		cbs_table.attach(cbs_label2, 0, 1, 1, 2)

		cbs_adj2 = Gtk::Adjustment.new(@board_height, 5, 30, 1, 5, 0)
		@cbs_entry2 = Gtk::SpinButton.new(cbs_adj2, 0, 0)
		cbs_table.attach(@cbs_entry2, 1, 2, 1, 2)

		# NUMの入力
		cbs_label3 = Gtk::Label.new("NUM:")
		cbs_table.attach(cbs_label3, 0, 1, 2, 3)

		cbs_adj3 = Gtk::Adjustment.new(@board_mine_num, 5, 200, 1, 5, 0)
		@cbs_entry3 = Gtk::SpinButton.new(cbs_adj3, 0, 0)
		cbs_table.attach(@cbs_entry3, 1, 2, 2, 3)

		# OK ボタン
		cbs_button = Gtk::Button.new("OK")
		cbs_button.signal_connect("clicked") do |widget|
#			@board_width = @cbs_entry1.get_text.to_i
			@board_width = @cbs_entry1.text.to_i
#			@board_height = @cbs_entry2.get_text.to_i
			@board_height = @cbs_entry2.text.to_i
#			@board_mine_num = @cbs_entry3.get_text.to_i
			@board_mine_num = @cbs_entry3.text.to_i
			renew()

			@cbs_show = false
			@cbs_window.destroy
		end
		cbs_table.attach(cbs_button, 0, 2, 3, 4)

		cbs_table.set_row_spacings(3)

		@cbs_window.show_all
	end

end

ms = MineSweep.new
Gtk.main # Gtkのループに入る

