#!/usr/local/bin/ruby -Ku

require "gtk2"
Gtk.init
require 'pstore' # pstoreの呼出

#### 初期設定
schedule = {}
act_year = Time.now.year
act_month = Time.now.month
act_day = Time.now.day

dir = ENV['HOME'].to_s + "/.rubygtk/"
file = dir + "schedule.pstore"
Dir.mkdir(dir) unless FileTest::directory?(dir) # ディレクトリがなければ作っておく

#### メソッド設定
# マークされている個所をチェックするメソッド
def mark_set(year, month, cal, schedule_data)
	# マークをすべて消す
	cal.clear_marks

	(1..31).each do |day| # 1-31日を繰り返す
		itsday = Time.local(year, month, day)
		break if itsday.month != month # 指定日が次の月だったら、飛ばす

		if schedule_data[itsday] && schedule_data[itsday][1]
			cal.mark_day(day) # マークを付ける
		end
	end
end

# スケジュールを記録
def save_schedule(schedule_data, itsday, schedule, importance)
	if schedule == "" && importance == false
		schedule_data.delete(itsday)
	else
		schedule_data[itsday] = [schedule, importance]
	end
	schedule_data
end

# 終了処理
def quit_operation(schedule, pstore, act_year, act_month, act_day, entry, checkbutton)
	# 今までの日の設定を記録
	itsday = Time.local(act_year, act_month, act_day)
#	text = entry.get_text
	text = entry.text
#	importance = checkbutton.active
	importance = checkbutton.active?

	# スケジュールを記録
	schedule = save_schedule(schedule, itsday, text, importance)

	# PStoreに書き込み
	pstore['schedule'] = schedule
	pstore.commit
end


#### ウィジェット作成
#window = Gtk::Window.new(Gtk::WINDOW_TOPLEVEL) # ウィンドウ作成
#window = Gtk::Window.new(Gtk::Window::TOPLEVEL) # ウィンドウ作成
window = Gtk::Window.new() # ウィンドウ作成
window.set_title("Schedule") # タイトルを付ける

vbox = Gtk::VBox.new(false, 5)

# カレンダー
frame = Gtk::Frame.new("Calendar")
cal = Gtk::Calendar.new

cal.select_month(act_month, act_year)
cal.select_day(act_day)

frame.add(cal)
vbox.pack_start(frame)

# セパレータ
separator = Gtk::HSeparator.new
vbox.pack_start(separator)

# フレームとその中のテーブル
frame2 = Gtk::Frame.new("Date")
vbox.pack_start(frame2)

fm2_table = Gtk::Table.new(3, 2, false)
frame2.add(fm2_table)

# ラベル
#label = Gtk::Label.new(Time.local(act_year, act_month, act_day).strftime("%Y-%m-%d(%a) の予定"))
label = Gtk::Label.new(Time.local(act_year, act_month, act_day).strftime("%Y-%m-%d の予定"))
fm2_table.attach(label, 0, 1, 0, 1) # labelをfm2_tableの中に入れる

# チェックボックス
checkbutton = Gtk::CheckButton.new("重要")
fm2_table.attach(checkbutton, 1, 2, 0, 1) # entryをfm2_tableの中に入れる

# エントリー
frame3 = Gtk::Frame.new("以下にスケジュールを入れて下さい")
entry = Gtk::Entry.new
frame3.add(entry)
fm2_table.attach(frame3, 0, 2, 1, 2) # entryをfm2_tableの中に入れる


# セパレータ
separator2 = Gtk::HSeparator.new
vbox.pack_start(separator2)

# ボタン
button = Gtk::Button::new("close")
#button.set_flags(Gtk::Widget::CAN_DEFAULT).grab_default
vbox.pack_start(button)

window.add(vbox) # ウィンドウにtableを追加
window.show_all # ウィンドウの表示


#### PStoreデータベースのトランザクションインに入る
pstore = PStore.new(file)
pstore.transaction do
	if pstore.root?('schedule')
		schedule = pstore['schedule']
		mark_set(act_year, act_month, cal, schedule) # マークをセット

		# 今日のデータがあったら表示
		today = Time.local(Time.now.year, Time.now.month, Time.now.day)
		if schedule[today] 
			entry.set_text(schedule[today][0])
			checkbutton.set_active(true) if schedule[today][1]
		end
	end

	#### シグナルの設定

	# チェックボタンを押す
	checkbutton.signal_connect('toggled') do
	#	year, month, day = cal.date
#		if checkbutton.active
		if checkbutton.active?
			cal.mark_day(act_day)
		else
			cal.unmark_day(act_day)
		end
	end

	# カレンダーを選択
	cal.signal_connect('day_selected') do
		# 今までの日の設定を記録
		itsday = Time.local(act_year, act_month, act_day)
#		text = entry.get_text
		text = entry.text
#		importance = checkbutton.active
		importance = checkbutton.active?

		# スケジュールを記録
		schedule = save_schedule(schedule, itsday, text, importance)

		# 新しい日を確認
		act_year, act_month, act_day = cal.date

		# ラベル変更
		itsday = Time.local(act_year, act_month, act_day)
#		label.set(itsday.strftime("%Y-%m-%d(%a) の予定"))
		label.set_text(itsday.strftime("%Y-%m-%d の予定"))

		# スケジュールが設定されている日だったら
		if schedule[itsday]
			entry.set_text(schedule[itsday][0]) # エントリー変更
			checkbutton.set_active(true) if schedule[itsday][1] # チェックボックス変更
		else
			entry.set_text("") # エントリー変更
			checkbutton.set_active(false) # チェックボックス変更
		end
	end

	# カレンダーの月の移動
	cal.signal_connect('month_changed') do
		year, month, day = cal.date # 新しい日を確認
		mark_set(year, month, cal, schedule) # マークをセット
	end

	# ウィンドウを終了（×ボタンなど）
	window.signal_connect('delete_event') do # 終了イベント
		quit_operation(schedule, pstore, act_year, act_month, act_day, entry, checkbutton)
	end

	# 終了ボタンをクリック
	button.signal_connect("clicked") do
		quit_operation(schedule, pstore, act_year, act_month, act_day, entry, checkbutton)
	end

	Gtk.main # Gtkのループに入る
end

