#!/usr/local/bin/ruby -Ke

require 'gtk' # gtkθƽ

class Shooting # Τ줿饹
	class CrashException < Exception; end
	class ScoreAddException < Exception; end

	Window = Gtk::Window.new()
	Window.realize

	DefaultFont = "-*-*-*-*-*-*-*-*-*-*-*-*-*-*"

	Window_width = 300
	Window_height = 300
	One_move_size = 10

	class Course # οʹԴ饹(ɽԤ)
		def initialize(drawable)
			@drawable = drawable

			@bg_pix = Gdk::Pixmap.new(drawable, Window_width, Window_height, -1)
			@bg = Background.new(@bg_pix) # طʤ
			gc = @bg.get_gc

			@current_pix = Gdk::Pixmap.new(drawable, Window_width, Window_height, -1)
			@current_pix.draw_pixmap(gc, @bg_pix, 0, 0, 0, 0, Window_width, Window_height)

			@space = Space.new(@drawable, @current_pix, @bg_pix)
			@my_ship = MyShip.new(@space)
			@step = 0
			@game = Game.new

			gc.destroy # GC˴
		end

		def next_step(right, down, missile)
			my_x, my_y, my_w, my_h = @my_ship.get_position
			right = right - my_x
			down = down - my_y

			# ư
			@my_ship.move(right, down) if right != 0 || down != 0
			@my_ship.shoot() if missile

			@space.get_objects.each do |object| # ¾֥Ȥư
				object.auto_move
			end

			begin # ֥ȤΥå
				@space.get_objects.each do |object|
					score = object.check
					@game.add_score(score) if score
				end
			rescue Shooting::CrashException
				return(true)
			end

			check_event # ٥ȡŨʤɡ

			# 
			@bg.next_step(@game) # طʤѲ
			gc = Gdk::GC.new(@bg_pix)  # GC
			@current_pix.draw_pixmap(gc, @bg_pix, 0, 0, 0, 0, Window_width, Window_height)
			gc.destroy

			@space.show_objects # ֥Ȥɽ

			gc = Gdk::GC.new(@drawable)  # GC
			@drawable.draw_pixmap(gc, @current_pix, 0, 0, 0, 0, Window_width, Window_height)
			gc.destroy

			@step += 1
			false # Ǥʤ
		end

		def check_event # Ũȯ
			if @space.get_enemy_ships.length == 0  # Ũʤни
				case Integer(rand() * 3)
				when 0
					(0..19).each do |i|
						Enemy1.new(@space, Integer(rand() * Window_width), -Integer(rand() * 500))
					end
				when 1
					(0..9).each do |i|
						Enemy2.new(@space, Integer(rand() * Window_width), -Integer(rand() * 500))
					end
				else
				end
			end
		end
	end

	class Game # ¸
		def initialize
			@score = 0
		end
		def get_score; @score; end
		def add_score(s); @score += s; end
	end

	class Space # ζ
		def initialize(drawable, current_pix, bg_pix)
			@drawable = drawable
			@current_pix = current_pix
			@bg_pix = bg_pix

			@objects = []
			@my_ship = nil
			@enemys = []
			@enemy_ships = []
		end

		def get_objects; @objects; end # ڡˤ륪֥Ȱ
		def get_my_ship; @my_ship; end
		def get_enemys; @enemys; end
		def get_enemy_ships; @enemy_ships; end

		def add_object(object) # ڡ˥֥Ȥɲ
			@objects << object
			@my_ship = object if object.kind_of?(Shooting::MyShip) # 
			@enemys << object if object.kind_of?(Shooting::Enemy) # Ũʤ
			@enemy_ships << object if object.kind_of?(Shooting::EnemyShip) # Ũʤ
		end
		def remove_object(object) # ڡ椫饪֥Ȥ
			@objects.delete(object)
			@enemys.delete(object) if object.kind_of?(Shooting::Enemy) # Ũʤ
			@enemy_ships.delete(object) if object.kind_of?(Shooting::EnemyShip) # Ũʤ
		end

		def show_objects # ֥Ȥcurrent_pixɽ
			gc = Gdk::GC.new(@bg_pix)  # GC

			@objects.each do |object|
				object.show(@current_pix, gc)
			end
		end
	end

	class Background # ط
		Star_num = 30
		def initialize(bg_pix)
			@bg_pix = bg_pix

			colormap = Gdk::Colormap.get_system()  # 顼ޥåפμФ
			@color_black = Gdk::Color.new(0x0000, 0x0000, 0x0000)    # κ 
			@color_white = Gdk::Color.new(0xffff, 0xffff, 0xffff)    # κ 
			colormap.alloc_color(@color_black, nil, true)    # ˥顼ޥåפ
			colormap.alloc_color(@color_white, nil, true)    # ˥顼ޥåפ

			@gc = Gdk::GC.new(@bg_pix)  # GC
			@gc.set_foreground(@color_black)  # GCΥե饦ɤ
			@bg_pix.draw_rectangle(@gc, true, 0, 0, Window_width, Window_height) # ɤĤ֤

			@stars = []
			(0..Star_num-1).each do |i|
				@stars << [Integer(rand() * Window_width), Integer(rand() * Window_height), 0]
			end
		end
		def get_gc; @gc; end # GC֤

		def next_step(game)
			@gc = Gdk::GC.new(@bg_pix)  # GC
			@gc.set_foreground(@color_black)  # GCΥե饦ɤ
			@bg_pix.draw_rectangle(@gc, true, 0, 0, Window_width, Window_height) # ɤĤ֤

			(0..Star_num-1).each do |i|
				if @stars[i]  # 
					if @stars[i][1] > Window_height # ֲǾä
						@stars[i] = nil
					else
						@gc.set_foreground(@color_white)  # GCΥե饦ɤ
						@bg_pix.draw_point( @gc, @stars[i][0], @stars[i][1] )
						@stars[i][1] += 1
					end
				else # ̵к
					if rand() < .5
						@stars << [Integer(rand() * Window_width), 0, 0]
					end
				end
			end
			@stars.compact!

			@gc.set_foreground(@color_white)  # GCΥե饦ɤ
			font = Gdk::Font.fontset_load(DefaultFont)
			@bg_pix.draw_string( font, @gc, 5, 30, "Score: #{game.get_score}" )
		end
	end

	class Object # Τ٤ƤΤ
		def initialize(space)
			@x = nil
			@y = nil
			@width = nil
			@height = nil
			@space = space
		end

		def add_to_space # ڡ˥֥Ȥɲ
			@space.add_object(self)
		end
		def remove_to_space # ڡ饪֥Ȥ
			@space.remove_object(self)
		end

		def get_position; [@x, @y, @width, @height]; end

		def auto_move; end

		def show(current_pix, gc) # ץ饤ɽ
			gc.set_clip_mask(@mask) # ֥ȤΥޥ
			gc.set_clip_origin(@x, @y) # ֥ȤΥץ饤ΰθ
			current_pix.draw_pixmap(gc, @pix, 0, 0, @x.to_f, @y.to_f, @width, @height)
			gc.set_clip_mask(nil) # Υޥ
		end

		def calc_distance(x1, y1, x2, y2)
			diff_x = x1.to_f - x2.to_f
			diff_y = y1.to_f - y2.to_f
			[Math.sqrt((diff_x ** 2) + (diff_y ** 2)), diff_x, diff_y]
		end

		def crash_check(x1, y1, w1, h1, x2, y2, w2, h2)
			left = x1 < x2 + w2
			right = x1 + w1 > x2
			top = y1 < y2 + h2
			bottom = y1 + h1 > y2
			if (left && right && top && bottom)
				true
			else
				false
			end
		end
	end

	class MyShip < Object # 
		Pix, Mask = Gdk::Pixmap.create_from_xpm(Window.window, nil, 'shooting_my_ship.xpm')
		Width = 20
		Height = 20

		def initialize(space)
			@space = space
			super(@space)
			@width = Width; @height = Height
			@x = (Window_width / 2) - (@width / 2)
			@y = Window_height * .75
			@pix = Pix
			@mask = Mask
			add_to_space()
		end

		def move(right, down)
			right = One_move_size if right > One_move_size
			right = -One_move_size if right < -One_move_size
			down = One_move_size if down > One_move_size
			down = -One_move_size if down < -One_move_size

			@x += right
			@y += down
		end

		def shoot
			MyMissile.new(@space, @x + (@width / 2) - (MyMissile::Width / 2), @y)
		end

		def check
			@x = 0 if @x < 0
			@x = Window_width - @width if @x > Window_width - @width
			@y = 0 if @y < 0
			@y = Window_height - @height if @y > Window_height - @height

			@space.get_enemys.each do |object|
				x, y, w, h = object.get_position
				raise Shooting::CrashException if crash_check(@x, @y, @width, @height, x, y, w, h)
			end
			nil
		end
	end

	class MyMissile < Object # ߥ
		Pix, Mask = Gdk::Pixmap.create_from_xpm(Window.window, nil, 'shooting_my_missile.xpm')
		Width = 6
		Height = 40
		One_move_size = 20

		def initialize(space, x, y)
			@space = space
			super(@space)
			@x = x; @y = y - 20
			@width = Width; @height = Height
			@pix = Pix
			@mask = Mask
			add_to_space()
		end

		def auto_move # ưŪʰư
			@y -= One_move_size
		end

		def check # å
			score = 0
			if @y < - @height
				remove_to_space
				@pix = @mask = nil
			end
			@space.get_enemy_ships.each do |object|
				x, y, w, h = object.get_position
				if crash_check(@x, @y, @width, @height, x, y, w, h)
					score = 0
					begin
						remove_to_space
						@pix = @mask = nil
						object.damage(1)
					rescue Shooting::ScoreAddException
						score += Integer(($!).to_s)
					end
				end
			end
			score
		end
	end

	class Enemy < Object # Ũ
		def initialize(space)
			@space = space
			super(@space)
		end

		def check_side # üΥå
			if @x < 0 || @x > Window_width - @width ||
			  @y < 0 || @y > Window_height - @height
				remove_to_space
				@pix = @mask = nil
			end
		end
	end

	class EnemyMissile < Enemy # Ũߥ
		Pix, Mask = Gdk::Pixmap.create_from_xpm(Window.window, nil, 'shooting_enemy_missile.xpm')
		Width = 4
		Height = 4

		def initialize(space, x, y)
			@space = space
			super(@space)
			@x = x.to_f; @y = y.to_f
			@width = Width; @height = Height
			@pix = Pix
			@mask = Mask
			add_to_space()

			my_x, my_y, my_w, my_h = @space.get_my_ship.get_position
			distance, diff_x, diff_y = calc_distance(my_x + my_w / 2, my_y + my_h / 2, @x, @y)
			magnification = (rand() * 4 + 4)
			@move_width = ((diff_x) / distance) * magnification
			@move_height = ((diff_y) / distance) * magnification
		end

		def auto_move # ưŪʰư
			@x += @move_width
			@y += @move_height
		end

		def check # å
			check_side
			nil
		end
	end

	class EnemyShip < Enemy # Ũ
		def initialize(space)
			@space = space
			super(@space)
		end

		def damage(damage_point) # ᡼Ϳ
			@power -= damage_point
			destroy() if @power <= 0
		end

		def destroy
			remove_to_space
			@pix = @mask = nil
			raise (Shooting::ScoreAddException, "#{@score}")
		end
	end

	class Enemy1 < EnemyShip # Ũ
		Pix, Mask = Gdk::Pixmap.create_from_xpm(Window.window, nil, 'shooting_enemy1.xpm')
		Width = 20
		Height = 20
		Power = 5
		Score = 100

		def initialize(space, x, y, exp = 0)
			@space = space
			super(@space)
			@x = x.to_f; @y = y.to_f
			@width = Width; @height = Height
			@power = Power
			@score = Score
			@pix = Pix
			@mask = Mask
			add_to_space()
		end

		def auto_move # ưŪʰư
			if @x < 10
				@x += 4
			elsif @x > Window_width - 10
				@x -= 4
			else
				@x += (Integer(rand() * 3) - 1) * 4
			end
			if @y < 10
				@y += 4
			elsif @y > 100
				@y -= 4
			else
				@y += Integer(rand() * 3 - 1) * 4
			end

			if rand() < .015
				EnemyMissile.new(@space, @x, @y)
			end
		end

		def check # å
			nil
		end
	end

	class Enemy2 < EnemyShip # Ũ
		Pix, Mask = Gdk::Pixmap.create_from_xpm(Window.window, nil, 'shooting_enemy2.xpm')
		Width = 20
		Height = 20
		Power = 1
		Score = 100

		def initialize(space, x, y, exp = 0)
			@space = space
			super(@space)
			@x = x.to_f; @y = y.to_f
			@width = Width; @height = Height
			@power = Power
			@status = 0
			@score = Score
			@pix = Pix
			@mask = Mask
			add_to_space()
		end

		def auto_move # ưŪʰư
			case @status
			when 0
				my_x, my_y, my_w, my_h = @space.get_my_ship.get_position
				w = -(@x - my_x)
				h = -(@y - 20)

				w = 4 if w > 4
				w = -4 if w < -4
				h = 4 if h > 4
				h = -12 if h < -12
				@x += w
				@y += h

				if @x + @width > my_x && @x < my_x + my_w && @y > 0
					@status = 1
					EnemyMissile.new(@space, @x, @y)
				end
			else
				h = 16
				@y += h
				@status = 0 if @y > Window_height
			end
		end

		def check # å
			nil
		end
	end


	def initialize
		@window = Gtk::Window.new()
		@window.signal_connect('delete_event'){ quit } # λ٥
		@window.position(Gtk::WIN_POS_CENTER) # ɽ

		vbox = Gtk::VBox.new(false)
		@window.add(vbox)

		fixed = Gtk::Fixed.new()  # FixedåȤǥ
		vbox.pack_start(fixed, false)

		@drawing_area = Gtk::DrawingArea.new()  # ɥꥢκ
		@drawing_area.size(Window_width, Window_height)  # ɥꥢ礭
		fixed.put(@drawing_area, 0, 0)

		button = Gtk::Button.new("START")  # ȥܥ
		vbox.pack_start(button, false)

		# ɽطΥ٥
		@drawing_area.signal_connect("expose_event") do |drawing_area, event| # 
			if @current_pix
				drawable = drawing_area.window  # ɥ֥Ф
				gc = Gdk::GC.new(drawable)  # GC
				drawable.draw_pixmap(gc, @current_pix, 0, 0, 0, 0,
					drawing_area.allocation.width, drawing_area.allocation.height)
				gc.destroy # GC˴
			end
		end

		# طΥ٥
		@mouse_x = @mouse_y = @mouse_button = true

		@window.set_events(Gdk::POINTER_MOTION_MASK | Gdk::POINTER_MOTION_HINT_MASK |
			Gdk::BUTTON_PRESS_MASK | Gdk::BUTTON_RELEASE_MASK)
		@window.signal_connect("motion_notify_event") do |widget, event|
			@mouse_x, @mouse_y = widget.window.get_pointer()
		end

		@window.signal_connect("button_press_event") do |widget, event|
			@mouse_button = nil if event.button() == 1
		end

		@window.signal_connect("button_release_event") do |widget, event|
			@mouse_button = true
		end

		@course = nil
		button.signal_connect("clicked") do |button| # ܥ󲡤ȳ
			@course = Course.new(@drawing_area.window)
			button.set_sensitive(false)
		end

		Gtk.timeout_add(100) do
			if @course # बϤƤ뤫
				dead = @course.next_step(@mouse_x, @mouse_y, @mouse_button)
				if dead
					@course = nil
					button.set_sensitive(true)
				end
			end
			true
		end


=begin
		@key_up = @key_down = @key_right = @key_left = nil
		@key_shift = nil

		@window.set_events(Gdk::KEY_PRESS_MASK | Gdk::KEY_RELEASE_MASK)
		@window.signal_connect("key_release_event") do |widget, event|
			@key_shift = nil if event.keyval == Gdk::GDK_Shift_L
		end

		@window.signal_connect("key_press_event") do |widget, event|
			case event.keyval
			when Gdk::GDK_Up      then @key_up = true
			when Gdk::GDK_Down    then @key_down = true
			when Gdk::GDK_Right   then @key_right = true
			when Gdk::GDK_Left    then @key_left = true
			when Gdk::GDK_Shift_L then @key_shift = true
			end
		end

		@course = nil
		button.signal_connect("clicked") do |button| # ܥ󲡤ȳ
			@course = Course.new(@drawing_area.window)
			button.set_sensitive(false)
		end

		Gtk.timeout_add(50) do
			if @course # बϤƤ뤫
				down = 0
				right = 0
				down -= 1 if @key_up     # 
				down += 1 if @key_down   # 
				right += 1 if @key_right # 
				right -= 1 if @key_left  # 
				@key_up = @key_down = @key_right = @key_left = nil

				dead = @course.next_step(right, down, @key_shift)
				if dead
					@course = nil
					button.set_sensitive(true)
				end
			end
			true
		end
=end

		@window.show_all
	end

	def quit
		Gtk::main_quit
	end
end

Shooting.new
Gtk.main

